const { spawn } = require("child_process");
const path = require("path");
require("dotenv").config();

async function startApp() {
  try {
	// Force the host to be 0.0.0.0
	process.env.IP = "0.0.0.0";
	process.env.HTTP_PORT = "3001";

	console.log('Starting app with:', { 
	  httpPort: process.env.HTTP_PORT,
	  host: process.env.IP 
	});

	// Start the Node.js application
	const app = spawn("node", [path.join(__dirname, "src", "index.js")], {
	  stdio: "inherit",
	  env: {
		...process.env,
		NODE_ENV: "production",
		HTTP_PORT: "3001",
		IP: "0.0.0.0"
	  }
	});

	app.on("error", (err) => {
	  console.error("Failed to start application:", err);
	  process.exit(1);
	});

	process.on("SIGTERM", () => {
	  app.kill();
	  process.exit(0);
	});
  } catch (error) {
	console.error("Error starting application:", error);
	process.exit(1);
  }
}

startApp();
